<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class Qoxag_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	 */

	public static function get_icons() {

		$icons = array(
				'xts-icon xts-fire' => 'xts-icon xts-fire',
				'xts-icon xts-eye' => 'xts-icon xts-eye',
				'xts-icon xts-arrow-up' => 'xts-icon xts-arrow-up',
				'xts-icon xts-chevron-up' => 'xts-icon xts-chevron-up',
				'xts-icon xts-chevron-down' => 'xts-icon xts-chevron-down',
				'xts-icon xts-times' => 'xts-icon xts-times',
				'xts-icon xts-circle' => 'xts-icon xts-circle',
				'xts-icon xts-dribbble' => 'xts-icon xts-dribbble',
				'xts-icon xts-envelope' => 'xts-icon xts-envelope',
				'xts-icon xts-phone-alt' => 'xts-icon xts-phone-alt',
				'xts-icon xts-pinterest' => 'xts-icon xts-pinterest',
				'xts-icon xts-rss' => 'xts-icon xts-rss',
				'xts-icon xts-user' => 'xts-icon xts-user',
				'xts-icon xts-youtube' => 'xts-icon xts-youtube',
				'xts-icon xts-menu' => 'xts-icon xts-menu',
				'xts-icon xts-arrow-left' => 'xts-icon xts-arrow-left',
				'xts-icon xts-arrow-right' => 'xts-icon xts-arrow-right',
				'xts-icon xts-author' => 'xts-icon xts-author',
				'xts-icon xts-category' => 'xts-icon xts-category',
				'xts-icon xts-chevron-left' => 'xts-icon xts-chevron-left',
				'xts-icon xts-chevron-right' => 'xts-icon xts-chevron-right',
				'xts-icon xts-date' => 'xts-icon xts-date',
				'xts-icon xts-search' => 'xts-icon xts-search',
				'xts-icon xts-audio_icon' => 'xts-icon xts-audio_icon',
				'xts-icon xts-image_icon' => 'xts-icon xts-image_icon',
				'xts-icon xts-play_icon' => 'xts-icon xts-play_icon',
				'xts-icon xts-home' => 'xts-icon xts-home',
				'xts-icon xts-facebook' => 'xts-icon xts-facebook',
				'xts-icon xts-instagram' => 'xts-icon xts-instagram',
				'xts-icon xts-twitter' => 'xts-icon xts-twitter',
				'xts-icon xts-vimeo' => 'xts-icon xts-vimeo',
				'xts-icon xts-linkedin' => 'xts-icon xts-linkedin',
				'xts-icon xts-bars' => 'xts-icon xts-bars',
				'xts-icon xts-spinner' => 'xts-icon xts-spinner',
				'xts-icon xts-quote-left' => 'xts-icon xts-quote-left',
				'xts-icon xts-quote-right' => 'xts-icon xts-quote-right',
				'xts-icon xts-comment' => 'xts-icon xts-comment',
				'xts-icon xts-moon' => 'xts-icon xts-moon',
				'xts-icon xts-star' => 'xts-icon xts-star',
				'xts-icon xts-star-half' => 'xts-icon xts-star-half',
				'xts-icon xts-sun' => 'xts-icon xts-sun',
				'xts-icon xts-clock-rewind' => 'xts-icon xts-clock-rewind',
				'xts-icon xts-peoples' => 'xts-icon xts-peoples',
				'xts-icon xts-printer' => 'xts-icon xts-printer',
				'xts-icon xts-share' => 'xts-icon xts-share',
				'xts-icon xts-clock' => 'xts-icon xts-clock',
		);

		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">

				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'qoxag' ); ?>">

					<option value=""><?php esc_html_e( 'Select Icon', 'qoxag' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}

}
